%% Code to generate Fig 4a
% AoA detection error vs SNR

clear all
close all
clc

aspread_aoa_set = [10;30;60]; 
case_val = 0;

aspread_aoa = aspread_aoa_set(1);
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load);
figure
semilogy(SNR_dB, (MSE_a_aoa_det), 'r--o','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_sd_aoa_det), 'b-o','LineWidth',1.2)
hold on


aspread_aoa = aspread_aoa_set(2);
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load);
semilogy(SNR_dB, (MSE_a_aoa_det), 'r--*','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_sd_aoa_det), 'b-*','LineWidth',1.2)
hold on

aspread_aoa = aspread_aoa_set(3);
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load);
semilogy(SNR_dB, (MSE_a_aoa_det), 'r--s','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_sd_aoa_det), 'b-s','LineWidth',1.2)
hold on

legend('UQ - 10^{0}','SD - 10^{0}', 'UQ - 30^{0}','SD - 30^{0}', 'UQ - 60^{0}','SD - 60^{0}');
xlabel('SNR (dB)')
ylabel('AoA estimation error (E_{\theta})')
grid on
ylim([10^(-4) 1.1])
xlim([-15 15])
savefig('Fig4a.fig')
saveas(gcf,'Fig4a','epsc')